%------------------------------------------------------------------------------
% File     : NUM711^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 30
% Version  : Especial.
% English  : ts x (pl y z) = pl (ts x y) (ts x z)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz30 [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 1.00 v3.7.0
% Syntax   : Number of formulae    :   21 (   0 unit;  11 type;   0 defn)
%            Number of atoms       :   89 (   7 equality;  39 variable)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :   65 (   0   ~;   0   |;   0   &;  60   @)
%                                         (   0 <=>;   5  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   11 (  11   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   13 (  11   :;   0   =)
%            Number of variables   :   18 (   0 sgn;  18   !;   0   ?;   0   ^)
%                                         (  18   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(y,type,(
    y: nat )).

thf(z,type,(
    z: nat )).

thf(ts,type,(
    ts: nat > nat > nat )).

thf(pl,type,(
    pl: nat > nat > nat )).

thf(set_type,type,(
    set: $tType )).

thf(esti,type,(
    esti: nat > set > $o )).

thf(setof,type,(
    setof: ( nat > $o ) > set )).

thf(estie,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( esti @ Xs @ ( setof @ Xp ) )
     => ( Xp @ Xs ) ) )).

thf(n_1,type,(
    n_1: nat )).

thf(suc,type,(
    suc: nat > nat )).

thf(ax5,axiom,(
    ! [Xs: set] :
      ( ( esti @ n_1 @ Xs )
     => ( ! [Xx: nat] :
            ( ( esti @ Xx @ Xs )
           => ( esti @ ( suc @ Xx ) @ Xs ) )
       => ! [Xx: nat] :
            ( esti @ Xx @ Xs ) ) ) )).

thf(estii,axiom,(
    ! [Xp: nat > $o,Xs: nat] :
      ( ( Xp @ Xs )
     => ( esti @ Xs @ ( setof @ Xp ) ) ) )).

thf(satz28e,axiom,(
    ! [Xx: nat] :
      ( Xx
      = ( ts @ Xx @ n_1 ) ) )).

thf(satz28b,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( ts @ Xx @ ( suc @ Xy ) )
      = ( pl @ ( ts @ Xx @ Xy ) @ Xx ) ) )).

thf(satz4a,axiom,(
    ! [Xx: nat] :
      ( ( pl @ Xx @ n_1 )
      = ( suc @ Xx ) ) )).

thf(satz28f,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( pl @ ( ts @ Xx @ Xy ) @ Xx )
      = ( ts @ Xx @ ( suc @ Xy ) ) ) )).

thf(satz5,axiom,(
    ! [Xx: nat,Xy: nat,Xz: nat] :
      ( ( pl @ ( pl @ Xx @ Xy ) @ Xz )
      = ( pl @ Xx @ ( pl @ Xy @ Xz ) ) ) )).

thf(satz4b,axiom,(
    ! [Xx: nat,Xy: nat] :
      ( ( pl @ Xx @ ( suc @ Xy ) )
      = ( suc @ ( pl @ Xx @ Xy ) ) ) )).

thf(satz30,conjecture,
    ( ( ts @ x @ ( pl @ y @ z ) )
    = ( pl @ ( ts @ x @ y ) @ ( ts @ x @ z ) ) )).

%------------------------------------------------------------------------------
